#!/bin/bash
#

function echo_red()
{
    echo -e "\E[0;31m$1"
    echo -e '\e[0m'
}

function echo_green()
{
    echo -e "\E[0;32m$1"
    echo -e '\e[0m'
}

function echo_yellow()
{
    echo -e "\E[1;33m$1"
    echo -e '\e[0m'
}

function exit_red()
{
    echo_red "$@"
    read -ep "Press [Enter] to return"
}

function die()
{
    echo -e "$@"
    exit 1
}

wpEnabled=false
server="www.webproj.jp"
rwlegacy_source="http://${server}/chromescripts/firmware/"
seabios_hswbdw_box="seabios-hswbdw_box-mrchromebox_20180912.bin"
seabios_kbl="seabios-kbl-mrchromebox_20180912.bin"

echo_green "chromeOS legacy boot enabling script."

[ "$(whoami)" = "root" ] || die "Run as Root"

if [ -f /etc/lsb-release ]; then
    cat /etc/lsb-release | grep "Chrome OS" > /dev/null 2>&1
    if [ $? -ne 0 ]; then
        isChromeOS=false
    fi
else
    exit_red "This is not ChromeOS";
    exit 1;
fi

_hwid=$(crossystem hwid | sed 's/ /_/g')

case "${_hwid}" in
    PANTHER*)
        _x='HSW|ASUS Chromebox CN60' ;
        seabios_file=$seabios_hswbdw_box;;
    GUADO*)
        _x='BDW|ASUS Chromebox 2 / CN62' ;
        seabios_file=$seabios_hswbdw_box;;
    TEEMO*)
        _x='KBL|Asus Chromebox 3 / CN65' ;
        seabios_file=$seabios_kbl;;
esac

# ライトプロテクト無効化
echo_green "disable write protect."

flashrom --wp-disable > /dev/null 2>&1
[[ $? -ne 0 ]] && wpEnabled=true

[[ "$wpEnabled" = true ]] && { exit_red  "\nHardware write-protect enabled, cannot set Boot Options / GBB Flags."; exit 1; }

# ファームウェアダウンロード
echo_yellow "\nDownloading RW_LEGACY firmware update\n(${rwlegacy_source}${seabios_file})"
curl -s -L -O ${rwlegacy_source}${seabios_file}.md5
curl -s -L -O ${rwlegacy_source}${seabios_file}
md5sum -c ${seabios_file}.md5 --quiet 2> /dev/null
[[ $? -ne 0 ]] && { exit_red "RW_LEGACY download checksum fail; download corrupted, cannot flash"; exit 1; }

echo_green "enable legacy boot."
crossystem dev_boot_legacy=1

echo_green "flash seabios."
flashrom -w -i RW_LEGACY:${seabios_file}

echo_green "set default boot flag."
/usr/share/vboot/bin/set_gbb_flags.sh 0x489